 aR  d  w  mP9      h	 oP      nSystem-wide
BootSlave: DO;

/* This is Os.BootSlave.Inc.  It is the part of   */
/* the PROM code (for the Communication Server and*/
/* Application Server cards) that reads in their  */
/* operating systems using simple message passing */
/* to a simplified file server on the fs card.    */

/* There are a few conditional statements in this */
/* module that distinguish comm server and appl   */
/* server cards.  If systemType = 1 then it is the*/
/* comm server; systemType = 2 is appl server.    */

$NOLIST
$INCLUDE (`w0`Incs`PlmLits.Inc~Text~)
$INCLUDE (`w0`OsIncs`Os.Error.Inc~Text~)
$INCLUDE (`w0`OsIncs`Os.Constant.Inc~Text~)
$INCLUDE (`w0`OsIncs`Os.Device.Inc~Text~)
$INCLUDE (`w0`OsIncs`Os.Type.Inc~Text~)
$INCLUDE (`w0`OsIncs`Os.Task.Type.Inc~Text~)
$INCLUDE(DiagMsgTypes.inc~Text~)
$LIST


/*                     Literals                   */

DCL sizeBootStack LIT '1000';
DCL addrBootStack LIT '01A000H';
$EJECT

/*                     Variables                  */

DCL cardId				BYTE EXTERNAL;
DCL cardType			BYTE EXTERNAL;
DCL bootTrace			BYTE EXTERNAL;

DCL bootCardId			BYTE EXTERNAL;

DCL osHeader			STRUCTURE
 (checksum	WORD,
  pBuf		PTR,
  pOs		PTR);

DCL oldStackPtr			WORD;
DCL oldStackBase		WORD;
DCL pStack				PTR;
DCL stackOffset			DWORD AT (@pStack);


/*       Arrays, Versions & Copyright Info       */

DCL divisors       (*) BYTE
  DATA (100, 10, 1);

DCL promVersion    (*) BYTE PUBLIC
  DATA ('Prom 3 11/17/84');

DCL copyRight      (*) BYTE PUBLIC
  DATA ('Copyright (c) 1983 GRiD Systems Corp.');


/*               External Procedures              */

MakeCheckSum: PROCEDURE (pBuffer, lenBuffer) WORD EXTERNAL;
  DCL lenBuffer WORD;
  DCL pBuffer   PTR;
  END;

ConCharOut: PROCEDURE (char) EXTERNAL;
  DCL char BYTE;
  END;

ConLineOut: PROCEDURE (pLine, lenLine) EXTERNAL;
  DCL lenLine WORD;
  DCL pLine   PTR;
  END;

CpAddressOf: PROCEDURE PTR EXTERNAL;
  END;

CpDisableInterrupt: PROCEDURE (interruptID) EXTERNAL;
  DCL interruptID BYTE;
  END;

CpEnableInterrupt: PROCEDURE (interruptID, mode) EXTERNAL;
  DCL interruptID BYTE;
  DCL mode        BYTE;
  END;

CpEndOfInterrupt: PROCEDURE (interruptID) EXTERNAL;
  DCL interruptID  BYTE;
  END;

CpSetMessageHandler: PROCEDURE (pNewHandler) PTR EXTERNAL;
  DCL pNewHandler PTR;
  END;

CpLogError: PROCEDURE (parm, pMsg) EXTERNAL;
  DCL parm        BYTE;
  DCL pMsg        PTR;
  END;
$CODE
$EJECT

/* This routine reports errors in two ways -     */
/*   1. To the console in the format:            */
/*         Cannot boot: xxx - n                  */
/*                                               */
/*   2. To the display in the format:            */
/*         1F xxx BOOTn                          */
/*                                               */
/*       (where xxx = errorCode, n = index)      */

ReportError: PROCEDURE (error) CLEAN;
  DCL error       WORD;

  DCL i           WORD;
  DCL errMsg (14) BYTE;

  errMsg  (0) = cardID + '0';
  errMsg  (1) = cardType;
  errMsg  (2) = ' ';
/* (3) - (5) is where the error digits go */
  errMsg  (6) = ' ';
  errMsg  (7) = 'B';
  errMsg  (8) = 'O';
  errMsg  (9) = 'O';
  errMsg (10) = 'T';
  errMsg (11) = bootTrace;
  errMsg (12) = cr;
  errMsg (13) = lf;

  DO i = 0 TO 2;
    BEGIN
    errMsg (i+3) = error / divisors (i) + '0';
    error = error MOD divisors (i);
    END;

  CALL CpLogError (1, @errMsg);
  CALL ConLineOut (@('Error: '), 7);
  CALL ConLineOut (@errMsg, 14);
  END; /* ReportError */
$EJECT

$IF (systemType <> 0)
/*                  Addr Msg Blk                  */

/* This routine returns the address of the message*/
/* block sent by 'fromCardID' to 'cardID'.        */

AddrMsgBlk: PROCEDURE (cardID, fromCardID) PTR CLEAN;
  DCL cardID        WORD;
  DCL fromCardID    WORD;

  DCL relFromCardID WORD;
  DCL pMsgBlk       PTR;
  DCL msgBlkAlias   STRUCTURE
   (offset           WORD,
    segment          WORD) AT (@pMsgBlk);

  relFromCardID = fromCardID;
  IF relFromCardID > cardID THEN
    relFromCardID = relFromCardID - 1;
  msgBlkAlias.segment = 
   startOfCR + sizeBootCR / 16 + (cardID * sizeMsgBlk / 16 * (maxNumCards - 1));
  msgBlkAlias.offset  = relFromCardID * sizeMsgBlk;
  RETURN (pMsgBlk);
  END; /* AddrMsgBlk */
$ENDIF
$EJECT
$IF (systemType <> 0)
/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/

DoMasterBoot: PROCEDURE PUBLIC;
	DO;
 DO WHILE TRUE;
   /* hang forever, since no local devices to boot from */
  END;
 END;
END DoMasterBoot;

$ENDIF


/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/

DoSlaveBoot: PROCEDURE PUBLIC;
	DCL error WORD;
	DO;

	 DISABLE;  /* dont want any more message interrupts to occur */
			   /* zzz may need to set diagnostic message handler too */

$IF testing
	 CALL HexOut(fsProcId);
	 CALL ConLineOut(@(' boot slave ready', cr, lf), 19);
$ENDIF

	 /* switch stack to ensure os code loading doesn't overwrite it */
	 
	 oldStackPtr = STACKPTR;
	 oldStackBase = STACKBASE;

	 pStack = addrBootStack;

	 STACKPTR = LOW (StackOffset) + sizeBootStack;
	 STACKBASE = HIGH (stackOffset);

	 error = ReceiveOsCode;

	 /* now return stack back */

	 STACKPTR = oldStackPtr;
	 STACKBASE = oldStackBase;

	 IF error = 0 THEN
	  DO;
	   /* let OS re-init this interrupt */
	   CALL CpDisableInterrupt (intMessage);
	   /* now "GOTO" to the OS initialization */
	   CALL osHeader.pOs;
	  END;
	 ELSE /* else return to main message handler to get next action */
	  /* zzz make this right string later */
	  CALL CpLogError (1, @('Boot Error'));

	END;
END DoSlaveBoot;


$EJECT
/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/

ReceiveOsCode: PROCEDURE WORD CLEAN;
	DCL pMyInterMsg		PTR;
	DCL myInterMsg		BASED pMyInterMsg interCardMsgType;
	DCL pOthersInterMsg	PTR;
	DCL othersInterMsg	BASED pOthersInterMsg interCardMsgType;
	DCL pDiagMsg		PTR;
	DCL diagMsg			BASED pDiagMsg diagnosticMsgType;
	DCL done			BYTE;
	DCL error			WORD;
	DCL bytesRead		WORD;
	DCL recvdLen		WORD;
	DCL timeOut			WORD;
	DCL buf				BASED osHeader.pBuf (1) BYTE;
	DCL checkSum		WORD;
	DCL entry			PTR;
	DO;
	 pMyInterMsg = AddrMsgBlk (cardId,
							   bootCardId);
	 pOthersInterMsg = AddrMsgBlk (bootCardId,
							 	   cardId);
	 pDiagMsg = @myInterMsg.restOfMsg;

	 osHeader.pBuf = nullPtr;
	 done = FALSE;
	 bytesRead = 0;

	 DO WHILE NOT done;
	  BEGIN
	   error = 0;

	   /* wait for receive msg */

	   timeout = 10000;
	   DO WHILE (myInterMsg.typeOfMsg = nullByte) AND (timeOut > 0);
	     CALL Time (50);
	     timeOut = timeOut - 1;
	    END;

	   CALL ConCharOut('.');

	   /* check for errors */

	   IF timeOut = 0 THEN
	    DO;
	     error = eTimeOut;
	    END;
	   ELSE
	    DO;
		 /* make sure message checkSum is valid, and right type of msg */
		 
	     checkSum = MakeCheckSum (@myInterMsg.spare1,
	   							  diagMsg.msgLength + 26);
	     IF checkSum <> myInterMsg.msgCheckSum THEN
		  error = eMsgCheckSum;
	     ELSE IF (diagMsg.ipcFunctionCode <> vipc_DiagnosticMsg) THEN
	      error = eParam;
	     ELSE IF (diagMsg.uMsgClass <> diagMsg_BootInfo) THEN
	      error = eParam;
	    END;

	   /* if no error, process boot data */

	   IF error = 0 THEN
	    DO;
	     /* get length of boot info data */

		 recvdLen = diagMsg.msgLength;

		 /* zero length means end of boot info */

	     IF recvdLen > 0 THEN
	      DO;
		   IF osHeader.pBuf = nullPtr THEN
		    DO;
		     /* if first read, set up os load header */
		     CALL MOVB (@diagMsg.msg,
		   			    @osHeader,
					    SIZE (osHeader));
			 recvdLen = recvdLen - SIZE(osHeader);

			 /* and read remainder of os load data */

		     CALL MOVB (@diagMsg.msg (SIZE (osHeader)),
		   			    @buf,
					    recvdLen);
		   	END;
		   ELSE
		    DO;
			 /* else move boot data into local ram */

		     CALL MOVB (@diagMsg.msg,
		   			    @buf(bytesRead),
					    recvdLen);
			END;

			/* keep track of total bytes */

	       bytesRead = bytesRead + recvdLen;

		  END;
	     ELSE
	      done = TRUE; /* end of boot recving */
	    END;

	   IF error <> eTimeOut THEN
		DO;
	     /* send message acknowledgement */

	     myInterMsg.typeOfMsg = nullByte;
	     othersInterMsg.ackCode = error;

	     OUTPUT (msgIntrPorts + bootCardId) = bootCardId;
		 
		 /* do this to clean up after polled exchange */
		 
		 CALL CpEndOfInterrupt (intMessage);
		 OUTWORD (msgIntReset) = 0;
		END;

	   /* if error encountered, then quit loop */

	   IF (error <> 0) AND (error <> eMsgCheckSum) THEN
		done = TRUE;
	  END;

	 IF error = 0 THEN
	  DO;
	   checkSum = MakeCheckSum (@osHeader.pBuf, 8)
	  				+ MakeCheckSum (osHeader.pBuf, bytesRead);

	   IF osHeader.checkSum <> checkSum THEN
      error = eCheckSum;
	  END;

	 RETURN error;

	END;
END ReceiveOsCode;

END; /* BootSlave */
